import sys
from Bio import SeqIO

target = sys.argv[1]
n = int(sys.argv[2])

output = open('script.sh', 'w')
for readno in ("READ1", "READ2"):
    filename = "seqlist_%s.fa" % readno
    total = 0
    print("Reading", filename)
    records = SeqIO.parse(filename, 'fasta')
    for record in records:
        total += 1
    count = total // n
    remainder = total - count * n
    end = 0
    for i in range(n):
        start = end
        end = start + count
        if i < remainder:
            end += 1
        script_rootname = "script_%s_%s_%d" % (target, readno, i)
        script_name = "%s.sh" % script_rootname
        handle = open(script_name, 'w')
        handle.write("""\
#!/bin/bash
#$ -cwd
#$ -e ./%s.stderr
#$ -o ./%s.stdout
#$ -v PYTHONPATH=/home/mdehoon/lib/python3.7/site-packages,LANG=en_US
#$ -l mem_free=4G
#$ -l h_vmem=4G
python filter.py %s %s %d %d
""" % (script_rootname, script_rootname, target, readno, start, end))
        handle.close()
        output.write('qsub -r n %s\n' % script_name)
    assert end == total

output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
